function [ value ] = sval2( d,delta,n,c,t )
%Evaluate \vec{c}\in S^r_d(delta) spline across vector points t.
%   d degree of polys, delta the extended knot sequence for S^r_d(delta), c
%   (row vector) the coefficients on normalized B-spline basis and t is a column vector
%   giving the x-coordinates of points in question. n is the dimension of
%   S^r_d(delta)

Membership = arrayfun(@(x) findinterval(n,delta,x),t); %Intervals in ext knot seq
                                                     %that points belong
value = arrayfun(@(x,y) sval(d,delta,c,x,y),t,Membership);
end

